import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import java.util.Date;


Connection con = null;
Statement st = null;
def log = LogFactoryUtil.getLog( 'Reindex WWW Layouts' )

try {
	con = DataAccess.getUpgradeOptimizedConnection();
	st = con.createStatement();
	ResultSet rs = st.executeQuery("select plid from Layout  where groupId = '8655930' and type_='content' and classNameId != 20002 and privateLayout = 0 order by friendlyURL ")
   log.info ("Started on - " +new Date());
	println("Started on - " +new Date());
    int cnt =1;    
         while (rs.next()) {
		    long id = rs.getLong(1);
			Layout l = LayoutLocalServiceUtil.getLayout(id);
            try {
				Indexer<Layout> indexer = IndexerRegistryUtil.getIndexer(Layout.class);
				indexer.reindex(l);
            log.info (cnt + ". Layout indexed is --------------->"+l.getFriendlyURL() )
				out.println(cnt + ". Layout indexed is --------------->"+l.getFriendlyURL() );
			} catch(Exception se) {
				out.println("Cannot Index Layout " + se.getMessage());
			
			}
			cnt++;
        
			
			  
        }
	println("Ended on - " +new Date());	
  log.info ("Ended on - " +new Date());
}catch(Exception e) {
	println(e.getMessage())
}
finally {
	DataAccess.cleanUp(con, st);
}